/*
 * Copyright 2009-2016 Cosmos Inc. All right reserved.
 * http://www.cos-mos.co.jp/
 */

// 作業SQL
var wkSql = "";
// 作業文字
var wkChar = "";
// 追加領域
var wkAdd = "";
// 開始位置
var startNo = 0;
// 終了位置
var endNo = 0;
// タブ文字
var tab = "";
// 括弧の未完回数
var parenthesis = 0;
// BETWEEN句の発生フラグ
var betweenFlg = false;
// UNION句の発生フラグ
var unionFlg = false;

// 単独でも稼働させるために設定（内容はconfig.jsを参照）
if (typeof configIndent === "undefined") {
	var configIndent = 1;
}
if (typeof configAndor === "undefined") {
	var configAndor = 3;
}
if (typeof configComma === "undefined") {
	var configComma = 2;
}
if (typeof configCaseFormat === "undefined") {
	var configCaseFormat = 1;
}
if (typeof configKeyword === "undefined") {
	var configKeyword = 1;
}
if (typeof configLineBreak === "undefined") {
	var configLineBreak = 1;
}
if (typeof configFormatSqlEnd === "undefined") {
	var configFormatSqlEnd = 1;
}

/**
 * グローバル変数をクリア
 */
function varClear() {

	wkSql = "";
	wkChar = "";
	wkAdd = "";
	startNo = 0;
	endNo = 0;
	tab = "";
	parenthesis = 0;
	betweenFlg = false;
	unionFlg = false;
}

/**
 * メイン処理
 */
function breakerDML(formatType, targetStr) {

	if (arguments.length > 2) {

		// 引数で渡された設定を採用（内容はconfig.jsを参照）
		if (typeof arguments[2] !== "undefined" && (arguments[2] == 1 || arguments[2] == 2)) {
			configIndent = arguments[2];
		}
		if (typeof arguments[3] !== "undefined" && (arguments[3] == 1 || arguments[3] == 2 || arguments[3] == 3)) {
			configAndor = arguments[3];
		}
		if (typeof arguments[4] !== "undefined" && (arguments[4] == 1 || arguments[4] == 2)) {
			configComma = arguments[4];
		}
		if (typeof arguments[5] !== "undefined" && (arguments[5] == 1 || arguments[5] == 2)) {
			configCaseFormat = arguments[5];
		}
		if (typeof arguments[6] !== "undefined" && (arguments[6] == 1 || arguments[6] == 2 || arguments[6] == 3)) {
			configKeyword = arguments[6];
		}
		if (typeof arguments[7] !== "undefined" && (arguments[7] == 1 || arguments[7] == 2)) {
			configLineBreak = arguments[7];
		}
		if (typeof arguments[8] !== "undefined" && (arguments[8] == 1 || arguments[8] == 2)) {
			configFormatSqlEnd = arguments[8];
		}
	}

	if (targetStr == null) {

		return;
	}

	// グローバル変数をクリア
	varClear();

	// 整形結果
	var formatResult = targetStr;

	// 末尾セミコロン付与フラグ
	var endSemicolonFlg = formatResult.indexOf(";") == -1;
	if (endSemicolonFlg) {
		formatResult = formatResult + ";";
	}

	// 先頭に半角スペースを付与、復帰文字と末尾の改行を除去
	formatResult = "__LF__" + formatResult.replace(/\r/g, "").replace(/\n*$/g, "");

	// 改行を変換（正規表現で複数行にマッチングさせるため／mオプションでは不可）
	formatResult = formatResult.replace(/\n/g, "__LF__");

	// クォーテーションで囲っている文字列を退避してから変換
	var quotationArray = formatResult.match(/'[^']*'|"[^"]*"/g);
	formatResult = formatResult.replace(/'[^']*'|"[^"]*"/g, "__QUOTATION__");

	// 整形対象の文字列を退避してから変換
	var regExp = new RegExp("__LF__ *(select|insert|update|delete)[ _][^;]*;", "gi");
	var formatArray = formatResult.match(regExp);
	formatResult = formatResult.replace(regExp, "__LF____FORMAT__");

	// 整形対象が存在しない場合
	if (formatArray == null) {

		return targetStr;
	}

	if (formatType == "DML") {

		// DML整形
		formatResult = formatDML(formatArray, formatResult);

	} else if (formatType == "LINE") {

		// 1行整形
		formatResult = formatLine(formatArray, formatResult);
	}

	// 先頭と末尾の改行を除去
	formatResult = formatResult.replace(/^__LF__|\n$/g, "");

	// 付与した末尾のセミコロンを除去
	if (endSemicolonFlg) {
		formatResult = formatResult.replace(/;$/g, "");
	}

	// 改行を設定に応じて変換
	formatResult = formatResult.replace(/__LF__/g, configLineBreak == 2 ? "\n" : "\r\n");

	// クォーテーションで囲っている文字列を復元
	if (quotationArray != null) {
		for (var i = 0; i < quotationArray.length; i++) {
			formatResult = formatResult.replace(/__QUOTATION__/, quotationArray[i]);
		}
	}

	// グローバル変数をクリア
	varClear();

	return formatResult;
}

/**
 * DML整形
 */
function formatDML(formatArray, formatResult) {

	for (var i = 0; i < formatArray.length; i++) {

		// 結果
		var result = "";

		wkSql = formatArray[i];
		wkAdd = "";
		startNo = 0;
		tab = "";
		parenthesis = 0;

		// コメントを退避してから変換
		var commentArray = wkSql.match(/\/\**?[^*]*\*\//g);
		wkSql = wkSql.replace(/\/\**?[^*]*\*\//g, "__COMMENT__");

		// union allを退避してから変換
		var unionAllArray = wkSql.match(/ union all /gi);
		wkSql = wkSql.replace(/ union all /gi, " __UNION_ALL__ ");

		// タブと改行を変換
		wkSql = wkSql.replace(/\t|__LF__/g, " ");

		// 余分な半角スペースを除去
		wkSql = formatTrim(wkSql);

		// SELECT
		if (wkSql.match(/^select /i) != null) {

			while (true) {

				result += formatSelect();

				if (unionFlg == false) {

					break;
				}

				wkAdd = "";
				startNo = endNo + 1;
				tab = "";
				parenthesis = 0;
			}

		// INSERT
		} else if (wkSql.match(/^insert /i) != null) {

			result = formatInsert();

		// UPDATE
		} else if (wkSql.match(/^update /i) != null) {

			result = formatUpdate();

		// DELETE
		} else if (wkSql.match(/^delete /i) != null) {

			result = formatDelete();

		} else {

			result = wkSql;
		}

		// 余分な半角スペースを除去
		result = formatTrim(result);

		// 半角スペースの代替を変換
		result = result.replace(/__SPACE__/g, " ");

		// インデントがスペース4の場合
		if (configIndent == 1) {
			result = result.replace(/\t/g, "    ");
		}

		// union allを復元
		if (unionAllArray != null) {
			for (var j = 0; j < unionAllArray.length; j++) {
				result = result.replace(/__UNION_ALL__/, unionAllArray[j].trim());
			}
		}

		if (configKeyword == 2 || configKeyword == 3) {

			// 予約語を変換
			result = convertKeyword(1, result);
		}

		// コメントを復元
		if (commentArray != null) {
			for (var j = 0; j < commentArray.length; j++) {
				result = result.replace(/__COMMENT__/, commentArray[j]);
			}
		}

		if (configFormatSqlEnd != 1) {

			// SQL間の空白行を付与（既に空白行がある場合は付与しない）
			formatResult = formatResult.replace(/__FORMAT____LF__(?!__LF__)/, "$&__LF__");
		}

		// 整形対象の文字列を整形結果で上書き
		formatResult = formatResult.replace(/__FORMAT__/, result);
	}

	return formatResult;
}

/**
 * 1行整形
 */
function formatLine(formatArray, formatResult) {

	for (var i = 0; i < formatArray.length; i++) {

		var result = formatArray[i];

		// 改行を除去、ホワイトスペースを変換
		result = result.replace(/__LF__/g, " ").replace(/\s+/g, " ");

		// 余分な半角スペースを除去
		result = formatTrim(result);

		if (configKeyword == 2 || configKeyword == 3) {

			// 予約語を変換
			result = convertKeyword(1, result);
		}

		if (configFormatSqlEnd != 1) {

			// SQL間の空白行を付与（既に空白行がある場合は付与しない）
			formatResult = formatResult.replace(/__FORMAT____LF__(?!__LF__)/, "$&__LF__");
		}

		// 整形対象の文字列を整形結果で上書き
		formatResult = formatResult.replace(/__FORMAT__/, result);

	}

	return formatResult;
}

/**
 * SELECTの整形処理
 */
function formatSelect() {

	var formatSql = "";

	unionFlg = false;

	if (wkSql.substring(startNo).match(/^select distinct /i) != null) {

		formatSql = wkSql.substring(startNo, startNo + 15) + "\n\t" + tab;
		startNo += 16;

	} else if (wkSql.substring(startNo).match(/^select /i) != null) {

		formatSql = wkSql.substring(startNo, startNo + 6) + "\n\t" + tab;
		startNo += 7;

	} else {

		formatSql = "\t";
	}

	for (var i = startNo; i < wkSql.length; i++) {

		wkChar = wkSql.charAt(i);
		endNo = i;

		if (wkChar == ")") {

			parenthesis--;

			if (parenthesis < 0) {

				formatSql += wkAdd;
				wkAdd = "\n" + tab;
				wkAdd = wkAdd.replace("\t", "");
				i = wkSql.length;
			}

			tab = tab.replace("\t", "");
		}

		wkAdd += wkChar;

		if (wkChar == "," && parenthesis == 0) {

			formatSql = formatComma(formatSql);

		} else if (wkChar == "(") {

			parenthesis++;
			tab = tab.concat("\t");

		} else if (wkAdd.match(/ and /i) != null) {

			formatSql = formatAnd(formatSql);

		} else if (wkAdd.match(/ or /i) != null) {

			formatSql = formatOr(formatSql);

		} else if (wkAdd.match(/ from /i) != null) {

			formatSql += wkAdd.substring(0, wkAdd.length - 5) + "\n" + tab + wkAdd.slice(-5);
			wkAdd = "\n\t" + tab;

		} else if (wkAdd.match(/ where /i) != null) {

			formatSql = formatWhere(formatSql);

		} else if (wkAdd.match(/ inner join | right join /i) != null) {

			formatSql += wkAdd.substring(0, wkAdd.length - 11) + "\n" + tab +  wkAdd.slice(-11);
			wkAdd = "\n\t" + tab;

		} else if (wkAdd.match(/ left join /i) != null) {

			formatSql += wkAdd.substring(0, wkAdd.length - 10) + "\n" + tab +  wkAdd.slice(-10);
			wkAdd = "\n\t" + tab;

		} else if (wkAdd.match(/ right outer join /i) != null) {

			formatSql += wkAdd.substring(0, wkAdd.length - 17) + "\n" + tab +  wkAdd.slice(-17);
			wkAdd = "\n\t" + tab;

		} else if (wkAdd.match(/ left outer join /i) != null) {

			formatSql += wkAdd.substring(0, wkAdd.length - 16) + "\n" + tab +  wkAdd.slice(-16);
			wkAdd = "\n\t" + tab;

		} else if (wkAdd.match(/ on /i) != null) {

			formatSql += wkAdd.substring(0, wkAdd.length - 3);

			// AND/OR/ON位置
			if (configAndor == 1) {
				formatSql += "\n" + tab + wkAdd.slice(-3);
				wkAdd = "__SPACE__"
			} else if (configAndor == 2) {
				formatSql += "\n\t" + tab + wkAdd.slice(-3);
				wkAdd = "__SPACE__"
			} else {
				formatSql += wkAdd.slice(-3);
				wkAdd = "\n\t" + tab;
			}

		} else if (wkAdd.match(/select /i) != null) {

			var parenthesis_bk = parenthesis;

			startNo = i - 6;
			parenthesis = 0;
			tab = tab.concat("\t");
			formatSql += wkAdd.substring(0, wkAdd.length - 7) + "\n" + tab;
			wkAdd = "";

			while (true) {

				formatSql += formatSelect();

				if (unionFlg == false) {

					break;
				}

				startNo = endNo + 1;
				parenthesis = 0;
				wkAdd = "";
			}

			i = endNo;
			parenthesis = parenthesis_bk + parenthesis;
			tab = tab.replace("\t", "");

		} else if (wkAdd.match(/ group by | order by /i) != null) {

			formatSql += wkAdd.substring(0, wkAdd.length - 9) + "\n" + tab + wkAdd.slice(-9);
			wkAdd = "\n\t" + tab;

		} else if (wkAdd.match(/ having /i) != null) {

			formatSql += wkAdd.substring(0, wkAdd.length - 7) + "\n" + tab + wkAdd.slice(-7);
			wkAdd = "\n\t" + tab;

		} else if (wkAdd.match(/ __UNION_ALL__ /) != null) {

			formatSql += wkAdd.substring(0, wkAdd.length - 14) + "\n" + tab + wkAdd.slice(-14);
			wkAdd = "\n" + tab;

			i = wkSql.length;
			unionFlg = true;

		} else if (wkAdd.match(/ union /i) != null) {

			formatSql += wkAdd.substring(0, wkAdd.length - 6) + "\n" + tab + wkAdd.slice(-6);
			wkAdd = "\n" + tab;

			i = wkSql.length;
			unionFlg = true;

		} else if (wkAdd.match(/ between /i) != null) {

			betweenFlg = true;

		} else if (configCaseFormat == 1) {

			formatSql = formatCase(formatSql);
		}
	}

	formatSql += wkAdd;
	wkAdd = "";

	// カンマ位置を調整
	if (configComma == 1) {
		formatSql = formatSql.replace(/, /g, ",");
	}

	return formatSql;
}

/**
 * INSERTの整形処理
 */
function formatInsert() {

	var formatSql = "";

	for (var i = startNo; i < wkSql.length; i++) {

		wkChar = wkSql.charAt(i);

		if (wkChar == ")") {

			parenthesis--;

			if (parenthesis <= 0) {

				wkAdd += "\n";
			}

			tab = tab.replace("\t", "");

		} else if (wkChar == "," && parenthesis == 1) {

			if (configComma == 1) {

				wkAdd += "\n" + tab;
			}
		}

		wkAdd += wkChar;

		if (wkChar == "," && parenthesis == 1) {

			if (configComma == 2) {

				wkAdd += "\n" + tab;
			}

		} else if (wkChar == "(") {

			parenthesis++;
			tab = tab.concat("\t");

			if (parenthesis == 1) {

				wkAdd += "\n" + tab;
			}

		} else if (wkAdd.match(/ values/i) != null) {

			formatSql += wkAdd.substring(0, wkAdd.length - 6) + "\n" + wkAdd.slice(-6);
			wkAdd = "";

		} else if (wkAdd.match(/select /i) != null) {


			if (wkAdd.match(/\(select /i) != null) {
				formatSql += wkAdd.substring(0, wkAdd.length - 7) + "\n" + tab;
			} else {
				formatSql += wkAdd.substring(0, wkAdd.length - 7) + "\t";
			}

			startNo = i - 6;
			wkAdd = "";

			if (parenthesis == 0) {

				formatSql += "\n" + tab;
			}

			parenthesis = 0;

			formatSql += formatSelect();

			i = endNo;
			parenthesis = 0;

		} else if (configCaseFormat == 1) {

			formatSql = formatCase(formatSql);
		}
	}

	formatSql += wkAdd;
	wkAdd = "";

	// カンマ位置を調整
	if (configComma == 1) {
		formatSql = formatSql.replace(/, /g, ",").replace(/values ?\(\n\t+/, "$&__SPACE__");
	}

	return formatSql;
}

/**
 * UPDATEの整形処理
 */
function formatUpdate() {

	var formatSql = "";

	endNo = wkSql.length;

	for (var i = startNo; i < wkSql.length; i++) {

		wkChar = wkSql.charAt(i);

		if (wkChar == ")") {

			parenthesis--;

			if (parenthesis < 0) {

				formatSql += wkAdd;
				wkAdd = "\n" + tab;
				wkAdd = wkAdd.replace( "\t", "" );
				endNo = i;
				i = wkSql.length;
			}

			tab = tab.replace("\t", "");
		}

		wkAdd += wkChar;

		if (wkChar == "," && parenthesis == 0) {

			formatSql = formatComma(formatSql);

		} else if (wkChar == "(") {

			parenthesis++;
			tab = tab.concat("\t");

		} else if (wkAdd.match(/ set /i) != null) {

			formatSql += wkAdd.substring(0, wkAdd.length - 4) + wkAdd.slice(-4);
			wkAdd = "\n\t";

		} else if (wkAdd.match(/ and /i) != null) {

			formatSql = formatAnd(formatSql);

		} else if (wkAdd.match(/ or /i) != null) {

			formatSql = formatOr(formatSql);

		} else if (wkAdd.match(/ where /i) != null) {

			formatSql = formatWhere(formatSql);

		} else if (wkAdd.match(/select /i) != null) {

			startNo = i - 6;
			parenthesis = 0;
			tab = tab.concat("\t");
			formatSql += wkAdd.substring(0, wkAdd.length - 7) + "\n" + tab;
			wkAdd = "";

			formatSql += formatSelect();

			startNo = endNo + 1;
			parenthesis = 0;
			wkAdd = "";

			i = endNo;
			parenthesis = 0;
			tab = tab.replace("\t", "");

		} else if (wkAdd.match(/ between /i) != null) {

			betweenFlg = true;

		} else if (configCaseFormat == 1) {

			formatSql = formatCase(formatSql);
		}
	}

	formatSql += wkAdd;
	wkAdd = "";

	return formatSql;
}

/**
 * DELETEの整形処理
 */
function formatDelete() {

	var formatSql = "";

	endNo = wkSql.length;

	for (var i = startNo; i < wkSql.length; i++) {

		wkChar = wkSql.charAt(i);

		if (wkChar == ")") {

			parenthesis--;

			if (parenthesis < 0) {

				formatSql += wkAdd;
				wkAdd = "\n" + tab;
				wkAdd = wkAdd.replace( "\t", "" );
				endNo = i;
				i = wkSql.length;
			}

			tab = tab.replace("\t", "");
		}

		wkAdd += wkChar;

		if (wkChar == "," && parenthesis == 0) {

			formatSql = formatComma(formatSql);

		} else if (wkChar == "(") {

			parenthesis++;
			tab = tab.concat("\t");

		} else if (wkAdd.match(/ and /i) != null) {

			formatSql = formatAnd(formatSql);

		} else if (wkAdd.match(/ or /i) != null) {

			formatSql = formatOr(formatSql);

		} else if (wkAdd.match(/ where /i) != null) {

			formatSql = formatWhere(formatSql);

		} else if (wkAdd.match(/select /i) != null) {

			startNo = i - 6;
			parenthesis = 0;
			tab = tab.concat("\t");
			formatSql += wkAdd.substring(0, wkAdd.length - 7) + "\n" + tab;
			wkAdd = "";

			formatSql += formatSelect();

			startNo = endNo + 1;
			parenthesis = 0;
			wkAdd = "";

			i = endNo;
			parenthesis = 0;
			tab = tab.replace("\t", "");

		} else if (wkAdd.match(/ between /i) != null) {

			betweenFlg = true;

		} else if (configCaseFormat == 1) {

			formatSql = formatCase(formatSql);
		}
	}

	formatSql += wkAdd;
	wkAdd = "";

	return formatSql;
}

/**
 * AND
 */
function formatAnd(formatSql) {

	formatSql += wkAdd.substring(0, wkAdd.length - 4);

	// AND/OR/ON位置が後の場合
	if (configAndor != 1 && configAndor != 2) {
		formatSql += wkAdd.slice(-4);
	}

	if (betweenFlg == true) {

		betweenFlg = false;

	} else {

		// AND/OR/ON位置が前2の場合
		if (configAndor == 2) {
			formatSql += "\n\t" + tab;
		} else {
			formatSql += "\n" + tab;
		}
	}

	// AND/OR/ON位置が前の場合
	if (configAndor == 1 || configAndor == 2) {
		formatSql += wkAdd.slice(-4);
	}

	wkAdd = "";

	return formatSql;
}

/**
 * OR
 */
function formatOr(formatSql) {

	formatSql += wkAdd.substring(0, wkAdd.length - 3);

	// AND/OR/ON位置に応じて設定
	if (configAndor == 1) {
		formatSql += "\n" + tab + wkAdd.slice(-3) + "__SPACE__";
	} else if (configAndor == 2) {
		formatSql += "\n\t" + tab + wkAdd.slice(-3) + "__SPACE__";
	} else {
		formatSql += wkAdd.slice(-3) + "\n\t" + tab;
	}

	wkAdd = "";

	return formatSql;
}

/**
 * WHERE
 */
function formatWhere(formatSql) {

	formatSql += wkAdd.substring(0, wkAdd.length - 6) + "\n" + tab + wkAdd.slice(-6);

	// AND/OR/ON位置が前2の場合
	if (configAndor == 2) {
		wkAdd = "\n\t\t" + tab;
	} else {
		wkAdd = "\n\t" + tab;
	}

	return formatSql;
}

/**
 * SELECT（副問い合わせ）
 */
function formatSubSelect(formatSql, i, pattern) {

	return formatSql;
}

/**
 * カンマ
 */
function formatComma(formatSql) {

	if (configComma == 1) {

		wkAdd = wkAdd.replace(/[a-z]+,$/, "__SPACE__$&").replace(/, *__SPACE__/, ",");
		formatSql += wkAdd.substring(0, wkAdd.length - 1);
		wkAdd = "\n\t" + tab + wkAdd.slice(-1);

	} else {

		formatSql += wkAdd;
		wkAdd = "\n\t" + tab;
	}

	return formatSql;
}

/**
 * CASE
 */
function formatCase(formatSql) {

	if (wkAdd.match(/ case |^case /i) != null) {

		formatSql += wkAdd;
		wkAdd = "";
		tab = tab.concat("\t");

	} else if (wkAdd.match(/ when | else /i) != null) {

		formatSql += wkAdd.substring(0, wkAdd.length - 6) + "\n\t\t" + tab + wkAdd.slice(-6);
		wkAdd = "";

	} else if (wkAdd.match(/ end /i) != null) {

		formatSql += wkAdd.substring(0, wkAdd.length - 5) + "\n\t\t" + tab + wkAdd.slice(-5) + "\n\t" + tab;
		wkAdd = "";
		tab = tab.replace("\t", "");
	}

	return formatSql;
}

/**
 * 余分な半角スペースを除去
 */
function formatTrim(targetStr) {

	while (true) {

		var wk = targetStr;

		targetStr = targetStr.replace(/^ +| +$/g, "");
		targetStr = targetStr.replace(/  /g, " ");
		targetStr = targetStr.replace(/ +\n/g, "\n");
		targetStr = targetStr.replace(/\t +/g, "\t");
		targetStr = targetStr.replace(/ +;/g, ";");
		targetStr = targetStr.replace(/__SPACE__ +/g, "__SPACE__");

		if (wk == targetStr) {

			return targetStr;
		}
	}
}


/**
 * 予約語を変換
 */
function convertKeyword(type, targetStr) {

	// DML予約語（38種類）
	var DML_KEYWORD = ["ALL", "AND", "ANY", "AS", "ASC", "BETWEEN", "BY", "CASE", "DELETE", "DESC", "DISTINCT", "ELSE", "END", "EXISTS", "FROM", "GROUP", "HAVING", "IN", "INDEX", "INNER", "INSERT", "INTO", "IS", "LIKE", "NOT", "NULL", "ON", "OR", "ORDER", "SELECT", "SET", "THEN", "UNION", "UPDATE", "VALUES", "WHERE", "WITH"];
	// Oracleキーワード（217種類）
	var ORACLE_KEYWORD = ["ABS", "ACOS", "ADD_MONTHS", "APPENDCHILDXML", "ATTIMEZONE", "ASCII", "ASCIISTR", "ASIN", "ATAN", "ATAN2", "AVG", "BFILENAME", "BIN_TO_NUM", "BITAND", "CARDINALITY", "CAST", "CEIL", "CHARTOROWID", "CHR", "COALESCE", "COLLECT", "COMPOSE", "CON_DBID_TO_ID", "CON_GUID_TO_ID", "CON_NAME_TO_ID", "CON_UID_TO_ID", "CONCAT", "CONVERT", "CORR", "CORR_K", "CORR_S", "COS", "COSH", "COUNT", "COVAR_POP", "COVAR_SAMP", "CUME_DIST", "CURRENT_DATE", "CURRENT_TIMESTAMP", "CV", "DATAOBJ_TO_PARTITION", "DBTIMEZONE", "DECODE", "DECOMPOSE", "DELETEXML", "DENSE_RANK", "DEPTH", "DEREF", "DUMP", "EMPTY_BLOB", "EMPTY_CLOB", "EXISTSNODE", "EXP", "EXTRACT", "EXTRACTVALUE", "FEATURE_DETAILS", "FEATURE_ID", "FEATURE_SET", "FEATURE_VALUE", "FIRST", "FIRST_VALUE", "FLOOR", "FROM_TZ", "GREATEST", "GROUP_ID", "GROUPING", "GROUPING_ID", "HEXTORAW", "INITCAP", "INSTR", "INSTRB", "IS_DATE", "ITERATION_NUMBER", "LAG", "LAST", "LAST_DAY", "LAST_VALUE", "LEAD", "LEAST", "LENGTH", "LENGTHB", "LISTAGG", "LN", "LNNVL", "LOCALTIMESTAMP", "LOG", "LOWER", "LPAD", "LTRIM", "MAKE_REF", "MAX", "MEDIAN", "MIN", "MOD", "MONTHS_BETWEEN", "NANVL", "NCHR", "NEW_TIME", "NEXT_DAY", "NLS_CHARSET_DECL_LEN", "NLS_CHARSET_ID", "NLS_CHARSET_NAME", "NLS_INITCAP", "NLS_LOWER", "NLS_UPPER", "NLSSORT", "NTH_VALUE", "NTILE", "NULLIF", "NUMTODSINTERVAL", "NUMTOYMINTERVAL", "NVL", "NVL2", "ORA_DST_AFFECTED", "ORA_DST_CONVERT", "ORA_DST_ERROR", "ORA_HASH", "ORA_INVOKING_USER", "ORA_INVOKING_USERID", "PATH", "PERCENT_RANK", "PERCENTILE_CONT", "PERCENTILE_DISC", "POWER", "POWERMULTISET", "POWERMULTISET_BY_CARDINALITY", "PRESENTNNV", "PRESENTV", "PREVIOUS", "RAWTOHEX", "RAWTONHEX", "REF", "REGEXP_COUNT", "REGEXP_INSTR", "REGEXP_LIKE", "REGEXP_REPLACE", "REGEXP_SUBSTR", "REMAINDER", "REPLACE", "ROUND", "ROW_NUMBER", "ROWIDTOCHAR", "ROWIDTONCHAR", "RPAD", "RTRIM", "SCN_TO_TIMESTAMP", "SESSIONTIMEZONE", "SET", "SIGN", "SIN", "SINH", "SOUNDEX", "SQLCODE", "SQLERRM", "SQRT", "STANDARD_HASH", "STRTOKEN", "STDDEV", "STDDEV_POP", "STDDEV_SAMP", "SUBSTR", "SUBSTRB", "SUM", "SYS_CONNECT_BY_PATH", "SYS_CONTEXT", "SYS_DBURIGEN", "SYS_EXTRACT_UTC", "SYS_GUID", "SYS_TYPEID", "SYS_XMLAGG", "SYS_XMLGEN", "SYSDATE", "SYSTIMESTAMP", "TAN", "TANH", "TIMESTAMP_TO_SCN", "TO_BINARY_DOUBLE", "TO_BINARY_FLOAT", "TO_BLOB", "TO_CHAR", "TO_CHAR", "TO_CLOB", "TO_DATE", "TO_DSINTERVAL", "TO_LOB", "TO_MULTI_BYTE", "TO_NCHAR", "TO_NCLOB", "TO_NUMBER", "TO_RAW", "TO_SINGLE_BYTE", "TO_TIMESTAMP", "TO_TIMESTAMP_TZ", "TO_YMINTERVAL", "TRANSLATE", "TREAT", "TRIM", "TRUNC", "TZ_OFFSET", "UID", "UNISTR", "UPDATEXML", "UPPER", "USER", "USERENV", "VALUE", "VAR_POP", "VAR_SAMP", "VARIANCE", "VSIZE", "WIDTH_BUCKET", "PREV_DAY", "IS_DATE", "YEARS_OF_AGE", "ROUNDUP", "STRTOKEN", "CD_MOD10_WEIGHT"];
	// JOINキーワード（10種類、予約語ではない）
	var JOIN_KEYWORD = ["CROSS JOIN", "FULL JOIN", "FULL OUTER JOIN", "INNER JOIN", "JOIN", "LEFT JOIN", "LEFT OUTER JOIN", "RIGHT JOIN", "RIGHT OUTER JOIN", "USING"];

	var key = "";
	var newStr = "";
	var sqlStr = type == 2 ? "<span class=\"highlight\">MATCH</span>" : "MATCH";
	var oracleStr = type == 2 ? "<span class=\"oracle\">MATCH</span>" : "MATCH";

	// DML予約語を太字の色付けに変換
	for (var i = 0; i < DML_KEYWORD.length; i++) {

		key = configKeyword == 2 ? DML_KEYWORD[i].toLowerCase() : DML_KEYWORD[i];
		newStr = sqlStr.replace("MATCH", configKeyword != 1 ? key : "$$&")
		targetStr = targetStr.replace(new RegExp("\\b" + key + "\\b", "ig"), newStr);
	}

	// Oracleキーワードを太字の色付けに変換
	for (var i = 0; i < ORACLE_KEYWORD.length; i++) {

		key = configKeyword == 2 ? ORACLE_KEYWORD[i].toLowerCase() : ORACLE_KEYWORD[i];
		newStr = oracleStr.replace("MATCH", configKeyword != 1 ? key : "$$&")
		targetStr = targetStr.replace(new RegExp("\\b" + key + "\\b", "ig"), newStr);
	}

	// JOINキーワードを太字の色付けに変換
	for (var i = 0; i < JOIN_KEYWORD.length; i++) {

		key = configKeyword == 2 ? JOIN_KEYWORD[i].toLowerCase() : JOIN_KEYWORD[i];
		newStr = oracleStr.replace("MATCH", configKeyword != 1 ? key : "$$&")
		targetStr = targetStr.replace(new RegExp("\\b" + key + "\\b", "ig"), newStr);
	}

	return  targetStr;
}
